#include "playercontrol.hpp"

PlayerControl::PlayerControl(IPlayerInput *cntrl, IUiInput *ui) :
  mCntrl(cntrl),
  mUi(ui)
{
}

PlayerControl::~PlayerControl()
{
  mCntrl->doStop();
}

void PlayerControl::playPause()
{
  switch(mStatus){
    case PAUSE:
      mCntrl->doStart();
      break;
    case PLAY:
      mCntrl->doPause();
      break;
    case STOP:
      break;
  }
}

void PlayerControl::stop()
{
  mCntrl->doStop();
}

void PlayerControl::started()
{
  mStatus = PLAY;
  mUi->sayPlay();
}

void PlayerControl::stopped()
{
  mStatus = STOP;
  mUi->sayStop();
}

void PlayerControl::paused()
{
  mStatus = PAUSE;
  mUi->sayPause();
}
